/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.controllers.data.TransportCategory;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.reflection.world.WorldReflection;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;

public class NoppesUtilServer {
    private static final HashMap<UUID, Quest> editingQuests = new HashMap();
    private static final HashMap<UUID, Quest> editingQuestsClient = new HashMap();
    private static final List<ITextComponent> errorMessagesToAdmin = new ArrayList<ITextComponent>();

    public static void createMobSpawner(BlockPos pos, NBTTagCompound comp, EntityPlayer player) {
        ServerCloneController.Instance.cleanTags(comp);
        if (comp.func_74779_i("id").equalsIgnoreCase("entityhorse")) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("Currently you cant create horse spawner, its a minecraft bug", new Object[0]));
            return;
        }
        player.field_70170_p.func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner tile = (TileEntityMobSpawner)player.field_70170_p.func_175625_s(pos);
        assert (tile != null);
        MobSpawnerBaseLogic logic = tile.func_145881_a();
        if (!comp.func_150297_b("id", 8)) {
            comp.func_74778_a("id", "Pig");
        }
        comp.func_74783_a("StartPosNew", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        logic.func_184993_a(new WeightedSpawnerEntity(1, comp));
    }

    public static void deleteEntity(EntityLivingBase entity) {
        Server.sendAssociatedData((Entity)entity, EnumPacketClient.DELETE_ENTITY, entity.func_145782_y());
    }

    public static BlockPos GetClosePos(BlockPos origin, World world) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 2; y >= -2; --y) {
                    BlockPos pos = origin.func_177982_a(x, y, z);
                    if (!world.isSideSolid(pos, EnumFacing.UP) || !world.func_175623_d(pos.func_177984_a()) || !world.func_175623_d(pos.func_177981_b(2))) continue;
                    return pos.func_177984_a();
                }
            }
        }
        return world.func_175672_r(origin);
    }

    public static Entity GetDamageSource(DamageSource damagesource) {
        Entity entity = damagesource.func_76346_g();
        if (entity == null) {
            entity = damagesource.func_76364_f();
        }
        if (entity instanceof EntityArrow && ((EntityArrow)entity).field_70250_c instanceof EntityLivingBase) {
            entity = ((EntityArrow)entity).field_70250_c;
        } else if (entity instanceof EntityThrowable) {
            entity = ((EntityThrowable)entity).func_85052_h();
        }
        if (entity == null && damagesource.func_76346_g() != null) {
            entity = damagesource.func_76346_g();
        }
        return entity;
    }

    public static EntityNPCInterface getEditingNpc(EntityPlayer player) {
        PlayerData data = PlayerData.get(player);
        return data.editingNpc;
    }

    public static Quest getEditingQuest(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return editingQuestsClient.get(player.func_110124_au());
        }
        return editingQuests.get(player.func_110124_au());
    }

    public static EntityPlayer getPlayer(MinecraftServer minecraftserver, UUID id) {
        List list = minecraftserver.func_184103_al().func_181057_v();
        for (EntityPlayer player : list) {
            if (!id.equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    private static Map<String, Integer> getScrollData(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (gui == EnumGuiType.PlayerTransporter) {
            RoleTransporter role = (RoleTransporter)npc.advanced.roleInterface;
            TransportLocation location = role.getLocation();
            String name = role.getLocation().name;
            for (TransportLocation loc : location.category.getDefaultLocations()) {
                if (map.containsKey(loc.name)) continue;
                map.put(loc.name, loc.id);
            }
            PlayerTransportData playerdata = PlayerData.get((EntityPlayer)player).transportData;
            for (int i : playerdata.transports) {
                TransportLocation loc = TransportController.getInstance().getTransport(i);
                if (loc == null || !location.category.locations.containsKey(loc.id) || map.containsKey(loc.name)) continue;
                map.put(loc.name, loc.id);
            }
            map.remove(name);
        }
        return map;
    }

    public static void GivePlayerItem(Entity entity, EntityPlayer player, ItemStack item) {
        if (entity.field_70170_p.field_72995_K || item == null || item.func_190926_b()) {
            return;
        }
        item = item.func_77946_l();
        float f = 0.7f;
        double d = entity.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f);
        double d2 = entity.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f);
        double d3 = entity.field_70170_p.field_73012_v.nextFloat() * f + (1.0f - f);
        EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t + d, entity.field_70163_u + d2, entity.field_70161_v + d3, item);
        entityitem.func_174867_a(2);
        entity.field_70170_p.func_72838_d((Entity)entityitem);
        int i = item.func_190916_E();
        if (player.field_71071_by.func_70441_a(item)) {
            entity.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)entityitem, i);
            PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
            for (QuestData data : playerdata.activeQuests.values()) {
                for (IQuestObjective obj : data.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                    if (obj.getType() != EnumQuestTask.ITEM.ordinal()) continue;
                    playerdata.checkQuestCompletion(player, data);
                }
            }
            if (item.func_190916_E() <= 0) {
                entityitem.func_70106_y();
            }
        }
    }

    public static boolean IsItemStackNull(ItemStack is) {
        return is == null || is.func_190926_b();
    }

    public static boolean isOp(EntityPlayer player) {
        return Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static void moveNpcDialogs(EntityPlayer player, int slot, boolean isUp) {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        if (npc == null) {
            return;
        }
        if (isUp && slot <= 0 || !isUp && slot >= npc.dialogs.length - 1) {
            return;
        }
        int[] newIDs = new int[npc.dialogs.length];
        for (int s = 0; s < npc.dialogs.length; ++s) {
            newIDs[s] = s + (isUp ? 1 : -1) == slot ? npc.dialogs[s + (isUp ? 1 : -1)] : (s == slot ? npc.dialogs[s + (isUp ? -1 : 1)] : npc.dialogs[s]);
            Dialog d = DialogController.instance.get(newIDs[s]);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Id", newIDs[s]);
            compound.func_74768_a("Slot", s);
            compound.func_74778_a("Category", d != null ? d.category.title : "");
            compound.func_74778_a("Title", d != null ? d.title : "null");
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.GUI_DATA, compound);
        }
        npc.dialogs = newIDs;
    }

    public static void moveNpcSpawn(EntityPlayerMP player, int slot, boolean isUp, boolean isDead) {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
        if (npc == null || !(npc.advanced.jobInterface instanceof JobSpawner)) {
            return;
        }
        JobSpawner job = (JobSpawner)npc.advanced.jobInterface;
        if (isUp && slot <= 0 || !isUp && slot >= job.size(isDead) - 1) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("JobData", true);
        npc.advanced.jobInterface.save(compound);
        job.cleanCompound(compound);
        Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
    }

    public static void NotifyOPs(ITextComponent message, boolean isError) {
        TextComponentString component = new TextComponentString("[CustomNPCs]");
        component.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        TextComponentString doubleDot = new TextComponentString(": ");
        doubleDot.func_150256_b().func_150238_a(TextFormatting.GRAY);
        component.func_150257_a((ITextComponent)doubleDot).func_150257_a(message);
        boolean isSend = false;
        for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            if (!player.func_174792_t_() || !NoppesUtilServer.isOp((EntityPlayer)player)) continue;
            if (isError) {
                Server.sendData(player, EnumPacketClient.SCRIPT_ERROR, ITextComponent.Serializer.func_150696_a((ITextComponent)component));
            } else {
                player.func_145747_a((ITextComponent)component);
            }
            isSend = true;
        }
        if (!isSend) {
            errorMessagesToAdmin.add((ITextComponent)component);
        }
        if (CustomNpcs.Server != null && CustomNpcs.Server.field_71305_c != null && CustomNpcs.Server.field_71305_c.length > 0 && CustomNpcs.Server.field_71305_c[0] != null && CustomNpcs.Server.field_71305_c[0].func_82736_K().func_82766_b("logAdminCommands")) {
            LogWriter.info(component.func_150260_c());
        }
    }

    public static void sendScriptErrorsTo(EntityPlayer player) {
        if (errorMessagesToAdmin.isEmpty() || player == null || CustomNpcs.Server == null || CustomNpcs.Server.field_71305_c == null || CustomNpcs.Server.field_71305_c.length == 0 || CustomNpcs.Server.field_71305_c[0] == null) {
            return;
        }
        for (ITextComponent component : errorMessagesToAdmin) {
            if (player instanceof EntityPlayerMP) {
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SCRIPT_ERROR, ITextComponent.Serializer.func_150696_a((ITextComponent)component));
                continue;
            }
            if (!CustomNpcs.DisplayErrorInChat) continue;
            player.func_145747_a(component);
        }
        errorMessagesToAdmin.clear();
    }

    public static void openDialog(EntityPlayer player, EntityNPCInterface npc, Dialog dia) {
        PlayerDialogData data;
        if (dia == null) {
            return;
        }
        Dialog dialog = dia.copy(player);
        PlayerData playerdata = PlayerData.get(player);
        if (EventHooks.onNPCDialog(npc, player, dialog)) {
            playerdata.dialogId = -1;
            return;
        }
        playerdata.dialogId = dialog.id;
        if (npc instanceof EntityDialogNpc || dia.id < 0) {
            dialog.hideNPC = true;
            Server.sendDataDelayed((EntityPlayerMP)player, EnumPacketClient.DIALOG_DUMMY, 100, npc.func_70005_c_(), dialog.save(new NBTTagCompound()));
        } else {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.DIALOG, npc.func_145782_y(), dialog.id);
        }
        dia.factionOptions.addPoints(player);
        if (dialog.hasQuest()) {
            PlayerQuestController.addActiveQuest(dialog.getQuest(), player, false);
        }
        if (!dialog.command.isEmpty()) {
            NoppesUtilServer.runCommand(npc, npc.func_70005_c_(), dialog.command, player);
        }
        if (dialog.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_184102_h(), player.func_70005_c_(), dialog.mail);
        }
        if (!(data = playerdata.dialogData).has(dialog.id) && dialog.id >= 0) {
            data.read(dialog.id);
            playerdata.updateClient = true;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        for (QuestData qdata : playerdata.questData.activeQuests.values()) {
            for (IQuestObjective obj : qdata.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                if (obj.getType() != EnumQuestTask.DIALOG.ordinal()) continue;
                playerdata.questData.checkQuestCompletion(player, qdata);
            }
        }
    }

    public static void playSound(EntityLivingBase entity, SoundEvent sound, float volume, float pitch) {
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, SoundCategory.NEUTRAL, volume, pitch);
    }

    public static void playSound(World world, BlockPos pos, SoundEvent sound, SoundCategory cat, float volume, float pitch) {
        world.func_184133_a(null, pos, sound, cat, volume, pitch);
    }

    public static void removePlayerData(int id, ByteBuf buffer, EntityPlayerMP player) {
        if (EnumPlayerData.values().length <= id) {
            return;
        }
        String name = Server.readString(buffer);
        if (name == null || name.isEmpty()) {
            return;
        }
        EnumPlayerData type = EnumPlayerData.values()[id];
        EntityPlayerMP pl = Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_152612_a(name);
        PlayerData playerdata = pl == null ? PlayerDataController.instance.getDataFromUsername(player.func_184102_h(), name) : PlayerData.get((EntityPlayer)pl);
        if (type == EnumPlayerData.Players) {
            File playerDir = new File(CustomNpcs.getWorldSaveDirectory("playerdata"), playerdata.uuid);
            if (playerDir.exists()) {
                Util.instance.removeFile(playerDir);
            }
            if (pl != null) {
                playerdata.setNBT(new NBTTagCompound());
                NoppesUtilServer.sendPlayerData(type, player, name);
                playerdata.save(true);
                return;
            }
        }
        if (pl != null) {
            SyncController.syncPlayer(pl);
        }
        NoppesUtilServer.sendPlayerData(type, player, name);
    }

    public static String runCommand(ICommandSender sender, String name, String command, EntityPlayer player) {
        return NoppesUtilServer.runCommand(sender.func_130014_f_(), sender.func_180425_c(), name, command, player, sender);
    }

    public static String runCommand(final World world, final BlockPos pos, final String name, String command, EntityPlayer player, final ICommandSender sender) {
        if (!Objects.requireNonNull(world.func_73046_m()).func_82356_Z()) {
            LogWriter.warn("Cant run commands if CommandBlocks are disabled");
            return "Cant run commands if CommandBlocks are disabled";
        }
        if (player != null) {
            command = command.replace("@dp", player.func_70005_c_());
        }
        command = command.replace("@npc", name);
        final TextComponentString output = new TextComponentString("");
        RConConsoleSource icommandsender = new RConConsoleSource(world.func_73046_m()){

            public boolean func_70003_b(int permLevel, @Nonnull String commandName) {
                return CustomNpcs.NpcUseOpCommands || permLevel <= 2;
            }

            public Entity func_174793_f() {
                if (sender == null) {
                    return null;
                }
                return sender.func_174793_f();
            }

            @Nonnull
            public ITextComponent func_145748_c_() {
                return new TextComponentString(this.func_70005_c_());
            }

            @Nonnull
            public World func_130014_f_() {
                return world;
            }

            @Nonnull
            public String func_70005_c_() {
                return "@CustomNPCs-" + name;
            }

            @Nonnull
            public BlockPos func_180425_c() {
                return pos;
            }

            @Nonnull
            public Vec3d func_174791_d() {
                return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            }

            public boolean func_174792_t_() {
                return Objects.requireNonNull(this.func_184102_h()).field_71305_c[0].func_82736_K().func_82766_b("commandBlockOutput");
            }

            public void func_145747_a(@Nonnull ITextComponent component) {
                output.func_150257_a(component);
            }
        };
        ICommandManager icommandmanager = world.func_73046_m().func_71187_D();
        icommandmanager.func_71556_a((ICommandSender)icommandsender, command);
        if (output.func_150260_c().isEmpty()) {
            return null;
        }
        return output.func_150260_c();
    }

    public static TileEntity saveTileEntity(EntityPlayerMP player, NBTTagCompound compound) {
        int z;
        int y;
        int x = compound.func_74762_e("x");
        TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(x, y = compound.func_74762_e("y"), z = compound.func_74762_e("z")));
        if (tile != null) {
            tile.func_145839_a(compound);
        }
        return tile;
    }

    public static void sendBank(EntityPlayerMP player, Bank bank, int ceil) {
        NBTTagCompound compound = new NBTTagCompound();
        bank.writeToNBT(compound);
        compound.func_74768_a("CurrentCeil", Math.max(ceil, 0));
        Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        if (player.field_71070_bA instanceof ContainerManageBanks) {
            ((ContainerManageBanks)player.field_71070_bA).setBank(bank, ceil);
        }
        player.func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
    }

    public static void sendBankDataAll(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Bank bank : BankController.getInstance().banks.values()) {
            map.put(bank.name, bank.id);
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    private static void sendExtraData(EntityPlayer player, EntityNPCInterface npc, EnumGuiType gui) {
        if (gui == EnumGuiType.PlayerFollower || gui == EnumGuiType.PlayerFollowerHire || gui == EnumGuiType.PlayerTrader || gui == EnumGuiType.PlayerTransporter) {
            NoppesUtilServer.sendRoleData(player, npc);
        }
    }

    public static void sendFactionDataAll(EntityPlayerMP player) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Faction faction : FactionController.instance.factions.values()) {
            map.put(faction.name, faction.id);
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void sendGuiClose(EntityPlayerMP player, int i, NBTTagCompound comp) {
        Server.sendData(player, EnumPacketClient.GUI_CLOSE, i, comp);
    }

    public static void sendGuiError(EntityPlayer player, int i) {
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.GUI_ERROR, i, new NBTTagCompound());
    }

    public static void sendNearbyEntitys(EntityPlayerMP player, boolean all) {
        HashMap<Float, NBTTagCompound> map = new HashMap<Float, NBTTagCompound>();
        ArrayList<Float> alist = new ArrayList<Float>();
        ArrayList<Float> nlist = new ArrayList<Float>();
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        ArrayList<Entity> entitys = new ArrayList<Entity>(player.field_70170_p.field_72996_f);
        for (Entity e : WorldReflection.getUnloadedEntityList(player.field_70170_p)) {
            if (entitys.contains(e)) continue;
            entitys.add(e);
        }
        for (Entity entity : entitys) {
            if (entity.field_70128_L || !all && !(entity instanceof EntityNPCInterface) || entity instanceof EntityPlayer && entity.func_70005_c_().equals(player.func_70005_c_())) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Id", entity.func_145782_y());
            nbt.func_74778_a("Name", entity.func_70005_c_());
            nbt.func_74778_a("Class", entity.getClass().getSimpleName());
            NBTTagList posList = new NBTTagList();
            posList.func_74742_a((NBTBase)new NBTTagDouble(entity.field_70165_t));
            posList.func_74742_a((NBTBase)new NBTTagDouble(entity.field_70163_u));
            posList.func_74742_a((NBTBase)new NBTTagDouble(entity.field_70161_v));
            nbt.func_74782_a("Pos", (NBTBase)posList);
            float distance = player.func_70032_d(entity);
            nbt.func_74776_a("Distance", distance);
            if (entity instanceof EntityNPCInterface) {
                nlist.add(Float.valueOf(distance));
            } else {
                alist.add(Float.valueOf(distance));
            }
            map.put(Float.valueOf(distance), nbt);
        }
        Collections.sort(alist);
        Collections.sort(nlist);
        Iterator<Object> iterator = nlist.iterator();
        while (iterator.hasNext()) {
            float d = ((Float)iterator.next()).floatValue();
            list.func_74742_a((NBTBase)map.get(Float.valueOf(d)));
        }
        iterator = alist.iterator();
        while (iterator.hasNext()) {
            float d = ((Float)iterator.next()).floatValue();
            list.func_74742_a((NBTBase)map.get(Float.valueOf(d)));
        }
        compound.func_74782_a("Data", (NBTBase)list);
        Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
    }

    public static void sendNpcDialogs(EntityPlayer player) {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        if (npc == null) {
            return;
        }
        int slot = 0;
        for (int dialogId : npc.dialogs) {
            if (!DialogController.instance.hasDialog(dialogId)) continue;
            Dialog d = DialogController.instance.get(dialogId);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Id", d.id);
            compound.func_74768_a("Slot", slot);
            compound.func_74778_a("Category", d.category.title);
            compound.func_74778_a("Title", d.title);
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.GUI_DATA, compound);
            ++slot;
        }
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        NoppesUtilServer.sendOpenGui(player, gui, npc, 0, 0, 0);
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc, int x, int y, int z) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        NoppesUtilServer.sendExtraData(player, npc, gui);
        CustomNPCsScheduler.runTack(() -> {
            try {
                if (CustomNpcs.proxy.getServerGuiElement(gui.ordinal(), player, player.field_70170_p, x, y, z) != null) {
                    player.openGui((Object)CustomNpcs.instance, gui.ordinal(), player.field_70170_p, x, y, z);
                    player.field_71070_bA.func_75142_b();
                } else {
                    Server.sendDataChecked((EntityPlayerMP)player, EnumPacketClient.GUI, gui.ordinal(), x, y, z);
                    Map<String, Integer> map = NoppesUtilServer.getScrollData(player, gui, npc);
                    NoppesUtilServer.sendScrollData((EntityPlayerMP)player, map);
                }
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }, 100);
    }

    public static void sendPlayerData(EnumPlayerData type, EntityPlayerMP player, String name) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (type == EnumPlayerData.Players) {
            for (String username : PlayerDataController.instance.getPlayerNames()) {
                map.put(username, 0);
            }
            for (String username : Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_72369_d()) {
                map.put(username, 1);
            }
        } else {
            PlayerData playerdata = PlayerDataController.instance.getDataFromUsername(Objects.requireNonNull(player.func_184102_h()), name);
            if (type == EnumPlayerData.Dialog) {
                PlayerDialogData data = playerdata.dialogData;
                for (int dialogId : data.dialogsRead.keySet()) {
                    Dialog dialog = DialogController.instance.dialogs.get(dialogId);
                    if (dialog == null) continue;
                    map.put(dialog.category.title + ": " + dialog.title, dialogId);
                }
            } else if (type == EnumPlayerData.Quest) {
                Quest quest;
                PlayerQuestData data2 = playerdata.questData;
                for (int questId : data2.activeQuests.keySet()) {
                    quest = QuestController.instance.quests.get(questId);
                    if (quest == null) continue;
                    map.put(quest.category.title + ": " + quest.getTitle() + "(Active quest)", questId);
                }
                for (int questId : data2.finishedQuests.keySet()) {
                    quest = QuestController.instance.quests.get(questId);
                    if (quest == null) continue;
                    map.put(quest.category.title + ": " + quest.getTitle() + "(Finished quest)", questId);
                }
            } else if (type == EnumPlayerData.Transport) {
                PlayerTransportData data3 = playerdata.transportData;
                for (int transportId : data3.transports) {
                    TransportLocation location = TransportController.getInstance().getTransport(transportId);
                    if (location == null) continue;
                    map.put(location.category.title + ": " + location.name, transportId);
                }
            } else if (type == EnumPlayerData.Factions) {
                PlayerFactionData data5 = playerdata.factionData;
                for (int factionId : data5.factionData.keySet()) {
                    Faction faction = FactionController.instance.factions.get(factionId);
                    if (faction == null) continue;
                    map.put(faction.name + ";" + data5.getFactionPoints((EntityPlayer)player, factionId), factionId);
                }
            } else if (type == EnumPlayerData.Game) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, playerdata.game.saveNBTData(new NBTTagCompound()));
            }
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void sendRoleData(EntityPlayer player, EntityNPCInterface npc) {
        if (npc == null) {
            return;
        }
        NBTTagCompound comp = new NBTTagCompound();
        npc.advanced.roleInterface.save(comp);
        comp.func_74768_a("EntityId", npc.func_145782_y());
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.ROLE, comp);
    }

    public static void sendScrollData(EntityPlayerMP player, Map<String, Integer> map) {
        HashMap<String, Integer> send = new HashMap<String, Integer>();
        for (String key : map.keySet()) {
            send.put(key, map.get(key));
            if (send.size() != 100) continue;
            Server.sendData(player, EnumPacketClient.SCROLL_DATA_PART, send);
            send = new HashMap();
        }
        Server.sendData(player, EnumPacketClient.SCROLL_DATA, send);
    }

    public static void sendTransportData(EntityPlayerMP player) {
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.TransportData, TransportController.getInstance().getNBT()});
        Server.sendData(player, EnumPacketClient.GUI_DATA, new NBTTagCompound());
    }

    public static void sendTransportData(EntityPlayerMP player, int categoryid) {
        TransportCategory category = TransportController.getInstance().categories.get(categoryid);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (category != null) {
            for (TransportLocation transport : category.locations.values()) {
                map.put(transport.name, transport.id);
            }
        } else {
            for (TransportCategory cat : TransportController.getInstance().categories.values()) {
                map.put(cat.title, cat.id);
            }
        }
        NoppesUtilServer.sendScrollData(player, map);
    }

    public static void setEditingNpc(EntityPlayer player, EntityNPCInterface npc) {
        PlayerData data = PlayerData.get(player);
        data.editingNpc = npc;
        Server.sendDataChecked((EntityPlayerMP)player, EnumPacketClient.EDIT_NPC, npc != null ? npc.func_145782_y() : -1);
    }

    public static void setEditingQuest(EntityPlayer player, Quest quest) {
        if (player.field_70170_p.field_72995_K) {
            editingQuestsClient.put(player.func_110124_au(), quest);
        } else {
            editingQuests.put(player.func_110124_au(), quest);
        }
    }

    public static NBTTagCompound setNpcDialog(int slot, int dialogId, EntityPlayer player) {
        EntityNPCInterface npc = NoppesUtilServer.getEditingNpc(player);
        if (npc == null || !DialogController.instance.hasDialog(dialogId)) {
            return new NBTTagCompound();
        }
        if (slot >= 0 && slot < npc.dialogs.length) {
            npc.dialogs[slot] = dialogId;
        } else {
            int[] newIDs = new int[npc.dialogs.length + 1];
            System.arraycopy(npc.dialogs, 0, newIDs, 0, npc.dialogs.length);
            slot = npc.dialogs.length;
            newIDs[slot] = dialogId;
            npc.dialogs = newIDs;
        }
        Dialog d = DialogController.instance.get(dialogId);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Id", d.id);
        compound.func_74768_a("Slot", slot);
        compound.func_74778_a("Category", d.category.title);
        compound.func_74778_a("Title", d.title);
        return compound;
    }

    public static Entity spawnClone(NBTTagCompound compound, double x, double y, double z, World world) {
        if (world == null || world.field_72995_K) {
            LogWriter.error("Clone summoning Error: World is Client: " + (world == null ? "null" : "true") + " - " + world);
            return null;
        }
        if (compound == null) {
            LogWriter.error("Clone summoning Error: Missing NBT Tags: null or World: " + world.field_73011_w.getDimension());
            return null;
        }
        ServerCloneController.Instance.cleanTags(compound);
        compound.func_74782_a("Pos", (NBTBase)NBTTags.nbtDoubleList(x, y, z));
        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)world);
        if (entity == null) {
            LogWriter.error("Clone summoning error: Failed to create an entity based on the passed NBT tags: " + compound);
            return null;
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_175449_a(new BlockPos(x, y, z), (int)((EntityCreature)entity).func_110174_bM());
        }
        world.func_72838_d(entity);
        LogWriter.debug("Summon Clone: Successful \"" + entity.func_70005_c_() + "\"; " + entity.field_70170_p.field_72995_K);
        return entity;
    }

    public static void spawnParticle(Entity entity, String particle) {
        Server.sendAssociatedData(entity, EnumPacketClient.PARTICLE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Float.valueOf(entity.field_70131_O), Float.valueOf(entity.field_70130_N), particle);
    }

    public static void sendScriptData(EntityPlayerMP player, NBTTagCompound compound, List<ScriptContainer> listContainers) {
        int tab;
        for (tab = 0; tab < compound.func_150295_c("Scripts", 10).func_74745_c(); ++tab) {
            NBTTagCompound tabNbt = compound.func_150295_c("Scripts", 10).func_150305_b(tab);
            tabNbt.func_74778_a("Script", "");
            tabNbt.func_74782_a("Console", (NBTBase)new NBTTagList());
        }
        compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages(false));
        compound.func_74778_a("DirPath", ScriptController.Instance.dir.getAbsolutePath());
        Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        tab = 0;
        for (ScriptContainer container : listContainers) {
            Server.sendData(player, EnumPacketClient.SCRIPT_CODE, tab, "");
            for (String part : Util.splitString(container.script, 128)) {
                Server.sendData(player, EnumPacketClient.SCRIPT_CODE, tab, part);
            }
            Iterator<Object> iterator = container.console.keySet().iterator();
            while (iterator.hasNext()) {
                long time = (Long)iterator.next();
                Server.sendData(player, EnumPacketClient.SCRIPT_CONSOLE, tab, time, "");
                for (String part : Util.splitString(container.console.get(time), 128)) {
                    Server.sendData(player, EnumPacketClient.SCRIPT_CONSOLE, tab, time, part);
                }
            }
            ++tab;
        }
        Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
    }
}

